/* Adobe.StartHereCaptions.js */
/*global define,console,nmlImpl */

define(	["lib/Zoot"],
		
	function(Z) {
		"use strict";

		var kAbout = "$$$/private/animal/Behavior/StartHereCaptions/About=Start Here Captions, (c) 2016.";

        //---------------------------------------------------------------------------
        // CAPTION DEFINITIONS
        // Replace these as needed. Times shouldn't overlap.
		// endTime is when the caption begins fading out. The fade is 0.5s long.
        //---------------------------------------------------------------------------
		var aCaptions = [
			{ startTime: 4.75,   endTime: 8.08,   caption: "$$$/animal/Behavior/StartHereCaptions/captions/c1=Hello? Somebody order pizza?" },
			{ startTime: 10,     endTime: 14.33,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c2=Oh! Sorry. Didn't hear you come in. Just practicing my keytar." },
			{ startTime: 15.25,  endTime: 20.33,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c3=I am Professor Victoria Von Funkenstein! Welcome to my laboratory!" },
			{ startTime: 20.5,   endTime: 25.33,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c4=Cool. So one pepperoni, extra cheese. Twenty-two fifty, plus tip." },
			{ startTime: 25.5,   endTime: 36.17,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c5=Oh. A tip? Well... how about a whole buncha' tips on how to use my latest and greatest invention? ADOBE CHARACTER ANIMATOR! BWA-HA-HA!" },
			{ startTime: 36.33,  endTime: 38.5,   caption: "$$$/animal/Behavior/StartHereCaptions/captions/c6=Most people just give me like two or three bucks." },
			{ startTime: 39.75,  endTime: 46.92,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c7=Taking an ordinary webcam and microphone, anyone can use Character Animator to pump their creations with PRECIOUS LIFE!" },
			{ startTime: 47.33,  endTime: 51.17,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c8=And today, \"Andrew\" here is going to help me demonstrate how." },
			{ startTime: 51.67,  endTime: 53.42,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c9=Um, ma'am? The pizza?" },
			{ startTime: 53.5,   endTime: 59.83,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c10=This mind control module will allow us to take control of Andrew's body - and let us have some fun." },
			{ startTime: 60.08,  endTime: 62.08,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c11=Did you say... mind control?" },
			{ startTime: 62.25,  endTime: 63.58,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c12=Stop wriggling!" },
			{ startTime: 63.67,  endTime: 65.83,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c13=What kind of doctor did you say you were again?" },
			{ startTime: 66,     endTime: 71,     caption: "$$$/animal/Behavior/StartHereCaptions/captions/c14=Oh I lost my doctor's license years ago. Now hold still while I turn this thing on!" },
			{ startTime: 71.17,  endTime: 74.83,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c15=I should really probably get going, I have a ton of deliver--" },
			{ startTime: 75.92,  endTime: 80.08,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c16=Hey, it worked! You wouldn't believe how many pizza boys I've gone through to get this right." },
			{ startTime: 80.25,  endTime: 83.83,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c17=Before you can control Andrew, first set your 'rest pose'." },
			{ startTime: 84.25,  endTime: 90.17,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c18=Look Andrew right in the eye, relax your face, and hit the 'Set Rest Pose' button over there." },
			{ startTime: 90.67,  endTime: 98.83,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c19=Then try moving your head back and forth, opening and closing your mouth, smiling and blinking your eyes - and Andrew will follow your movements." },
			{ startTime: 101.67, endTime: 103.75, caption: "$$$/animal/Behavior/StartHereCaptions/captions/c20=We've got more experiments to get through!" },
			{ startTime: 104.67, endTime: 107.5,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c21=Oh geez. What's this thing do?" },
			{ startTime: 107.75, endTime: 113.67, caption: "$$$/animal/Behavior/StartHereCaptions/captions/c22=This machine will transform your soft fleshy human body into an entirely new being, Andrew!" },
			{ startTime: 113.83, endTime: 120.58, caption: "$$$/animal/Behavior/StartHereCaptions/captions/c23=It harnesses the DARK ARTS to bring my creations to life! BWA-HA-HA-HA-HA!" },
			{ startTime: 120.83, endTime: 127.92, caption: "$$$/animal/Behavior/StartHereCaptions/captions/c24=But to put it another way - it uses Photoshop and Illustrator. I designed this creature in Photoshop, but Illustrator works too." },
			{ startTime: 128.33, endTime: 130.33, caption: "$$$/animal/Behavior/StartHereCaptions/captions/c25=Prepare to import artwork!" },
			{ startTime: 131,    endTime: 132.08, caption: "$$$/animal/Behavior/StartHereCaptions/captions/c26=Is this dangerous?" },
			{ startTime: 132.17, endTime: 135.75, caption: "$$$/animal/Behavior/StartHereCaptions/captions/c27=Oh no, I'll be quite safe behind this protective barrier Andrew." },
			{ startTime: 139.33, endTime: 141.5,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c28=IT'S ALIVE!" },
			{ startTime: 144.92, endTime: 147,    caption: "$$$/animal/Behavior/StartHereCaptions/captions/c29=Character Animator does lip sync too." },
			{ startTime: 147.5,  endTime: 149.67, caption: "$$$/animal/Behavior/StartHereCaptions/captions/c30=Let's pick one of these heads to try it out!" },
			{ startTime: 150.25, endTime: 154.25, caption: "$$$/animal/Behavior/StartHereCaptions/captions/c31=Hmm... Maggot Brain... Zombie... Napoleon... Aha!" },
			{ startTime: 154.67, endTime: 156.83, caption: "$$$/animal/Behavior/StartHereCaptions/captions/c32=Let's try it on this funky UFO!" },
			{ startTime: 157.83, endTime: 160.5,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c33=Talk into your mic and give it a go when I hit the power!" },
			{ startTime: 164.83, endTime: 169.67, caption: "$$$/animal/Behavior/StartHereCaptions/captions/c34=For my last experiment, allow me to introduce... FUNK-BOT 5000!" },
			{ startTime: 169.83, endTime: 180,    caption: "$$$/animal/Behavior/StartHereCaptions/captions/c35=This state-of-the-art metal man will help me demonstrate complete control and absolute power over your subservient creations! BWA-HA-HA-HA!" },
			{ startTime: 180.92, endTime: 188.58, caption: "$$$/animal/Behavior/StartHereCaptions/captions/c36=You can use a keyboard to control your puppets, and a mouse or touch screen to drag around arms, legs, tentacles - whatever!" },
			{ startTime: 189.25, endTime: 192.33, caption: "$$$/animal/Behavior/StartHereCaptions/captions/c37=Aha! Andrew! Back to your old self I see." },
			{ startTime: 194.25, endTime: 198.25, caption: "$$$/animal/Behavior/StartHereCaptions/captions/c38=I'm going to transfer Andrew's soft, squishy brain into the Funk-Bot -" },
			{ startTime: 198.92, endTime: 201.25, caption: "$$$/animal/Behavior/StartHereCaptions/captions/c39=use your keyboard and mouse to control it!" },
			{ startTime: 205.42, endTime: 207.83, caption: "$$$/animal/Behavior/StartHereCaptions/captions/c40=Well, I think that's enough science for today." },
			{ startTime: 208.08, endTime: 212.25, caption: "$$$/animal/Behavior/StartHereCaptions/captions/c41=If you want to keep experimenting, check out the other tutorials, over here" },
			{ startTime: 212.58, endTime: 213.83, caption: "$$$/animal/Behavior/StartHereCaptions/captions/c42=Say goodbye, Andrew." },
			{ startTime: 214,    endTime: 215.5,  caption: "$$$/animal/Behavior/StartHereCaptions/captions/c43=GOOD. BYE." },
			{ startTime: 216.17, endTime: 217.92, caption: "$$$/animal/Behavior/StartHereCaptions/captions/c44=Where did I put that pizza?" },
		];
        //---------------------------------------------------------------------------

		function findCaptionForTime (t, hintIdx) {
			function isInRange(idx) {
				return aCaptions[idx] && t >= aCaptions[idx].startTime && t <= aCaptions[idx].endTime;
			}

			if (typeof(hintIdx) === "number" && isInRange(hintIdx)) {
				return hintIdx;
			} else {
				for (var i = 0; i < aCaptions.length; i++) {
					if (isInRange(i)) {
						return i;
					}
				}
			}
		}
		
		return {
			about: kAbout,
			uiName:	"$$$/animal/Behavior/StartHereCaptions/UIName=Start Here Captions",
			description: "$$$/animal/Behavior/StartHereCaptions/Desc=Display captions at specific tutorial playback times.",
			hideInBehaviorList: true, // to see this behavior, press opt/alt when clicking the + menu
			defaultArmedForRecordOn: false,
			defaultHideInTrackItemProperties: true,

			defineParams: function () {
				return [
				{id: "EnglishCaptions", type: "checkbox", uiName: "Show Captions in English", dephault: false },
				];
			},

			onCreateBackStageBehavior: function (self) {
			},
			
			onCreateStageBehavior: function (self, backstageBehavior, stagePuppet) {
			},
			
			onParamChanged: function (self, args)  {
			},
			
			//  args includes t, dt, stagePuppet, getParam(id), getParamEventValue()
			onAnimate: function (self, args) {
				// don't show captions in English
				if (!args.getParam("EnglishCaptions") && nmlImpl.langCode === "en_US")
					return;

				var view = args.stagePuppet.getView();
				if (view.isPlaying() && !view.isScrubbing() && !view.isRecording()) {
					var t = view.getPlaybackTime();
					if (typeof(self.lastIndex) === "number" && t <= self.lastEndTime) {
						// do nothing, we're good
					} else {
						var hintIdx = typeof(self.lastIndex) === "number" && self.lastIndex + 1;
						var idx = findCaptionForTime(t, hintIdx);
						if (typeof(idx) === "number") {
							var captionInfo = aCaptions[idx];
							var captionDuration = captionInfo.endTime - t;
							Z.nml.displayMessage(captionInfo.caption, captionDuration);
							
							self.lastIndex = idx;
							self.lastEndTime = captionInfo.endTime;
						} else {
							// nothing found for this time
						}
					}
				} else {
					// reset state
					self.lastIndex = null;
					self.lastEndTime = null;
				}
			}
		};
	}
);

